// SPDX-FileCopyrightText: 2023 g10 code GmbH
// SPDX-Contributor: Carl Schwan <carl.schwan@gnupg.com>
// SPDX-License-Identifier: GPL-2.0-or-later

#pragma once

#include <QtGlobal>
#include <memory>

class Controller;

class TrustStore
{
public:
    explicit TrustStore();
    ~TrustStore();

    /// Install the trust store to the platform
    bool install(const Controller &controller);

    /// Uninstall the trust store to the platform
    bool uninstall(const Controller &controller);

    QString systemTrustFilename(const Controller &controller) const;
};
