// SPDX-FileCopyrightText: 2024 g10 code Gmbh
// SPDX-Contributor: Carl Schwan <carl.schwan@gnupg.com>
// SPDX-License-Identifier: GPL-2.0-or-later

#pragma once

#include "utils/systemtrayicon.h"
#include <QMainWindow>
#include <QPointer>
#include <QProcess>
#include <memory>

class QLabel;
class Controller;

namespace Ui
{
class FirstTimeDialog;
class ConfPageWelcome;
class ConfPageInstallAddin;
class ConfPageProxyOptions;
class ConfPageTLSCertificate;
}

class FirstTimeDialog : public QMainWindow
{
    Q_OBJECT
public:
    explicit FirstTimeDialog(QWidget *parent = nullptr);
    ~FirstTimeDialog();

    QString serverDomain() const;

public Q_SLOTS:
    void slotStateChanged(const QString &stateDisplay);
    void slotTlsDebutOutput(const QString &output);

protected:
    void closeEvent(QCloseEvent *e) override;
    void generateManifest();

private:
    void slotSetup();
    void startLocalServer();
    void startWebsocketClient();

    enum Page {
        ConfPageWelcome = 0,
        ConfPageProxyOptions = 1,
        ManifestPage = 2,
        ConfPageTLSCertificate = 3,
    };

    std::unique_ptr<Ui::FirstTimeDialog> ui;
    std::unique_ptr<Ui::ConfPageWelcome> confPageWelcome;
    std::unique_ptr<Ui::ConfPageInstallAddin> confPageInstallAddin;
    std::unique_ptr<Ui::ConfPageProxyOptions> confPageProxyOptions;
    std::unique_ptr<Ui::ConfPageTLSCertificate> confPageTLSCertificate;
    QAction *m_backAction;
    QLabel *m_status;
    QPointer<Controller> m_controller;
    SystemTrayIcon m_systemTrayIcon;
    QProcess m_serverProcess;
};
