// SPDX-FileCopyrightText: 2025 g10 code GmbH
// SPDX-FileContributor: Carl Schwan <carl.schwan@gnupg.com>
// SPDX-License-Identifier: GPL-2.0-or-later

#pragma once

#include "choosekeydialog.h"
#include "ews/ewsclient.h"
#include "ews/ewsfolder.h"
#include "ews/ewsid.h"
#include "ews/ewsitem.h"
#include <KJob>
#include <KMime/Message>
#include <QGpgME/EncryptJob>
#include <QLabel>
#include <QQueue>
#include <QUrl>
#include <QVariant>

class QPlainTextEdit;
class QStandardItemModel;
class QStandardItem;
class WebsocketClient;
class EwsGetFolderContentRequest;

namespace QGpgME
{
class EncryptJob;
}

struct ReencryptSubJobs {
    EwsItem item;
    QList<QGpgME::EncryptJob *> encryptJobs;
    QStandardItem *modelItem;
    KMime::Message::Ptr message;

    bool isEncrypted() const
    {
        return !encryptJobs.isEmpty();
    }
};

class ReencryptJob : public KJob
{
public:
    explicit ReencryptJob(WebsocketClient *websocketClient, const EwsId &folderId, const EwsClient &client);

    void start() override;

    void reencrypt();

private:
    void createNewFolder(int index = 0);
    void parseParts(const EwsItem &item, KMime::Content *content, std::shared_ptr<ReencryptSubJobs> subJobs);
    void encryptionFinished(const EwsItem &item, QGpgME::EncryptJob *job, const GpgME::EncryptionResult &result, const QByteArray &cipherText);

    void saveAsNew(const EwsId &itemId, const QByteArray &mimeContent, QStandardItem *index);
    void saveCopy(const EwsId &item, QStandardItem *index);

    std::vector<GpgME::Key> m_currentKeys;
    UnencryptedMode m_unencryptedMode = UnencryptedMode::Skip;
    QUrl m_backupFolder;
    QList<QGpgME::EncryptJob *> m_encryptJobs;
    QStandardItemModel *const m_itemModel;
    QLabel *m_title;
    QPlainTextEdit *m_debugLog;
    WebsocketClient *m_websocketClient;
    EwsId m_folderId;
    EwsId m_newFolderId;
    EwsFolder m_folder;
    EwsClient m_ewsClient;
    QQueue<EwsItem> m_itemsToReencrypt;
    EwsGetFolderContentRequest *m_getFolderContentRequest = nullptr;
    bool m_reencrypting = false;
    int m_countReencrypted = 0;
    bool m_finished = false;
};
